//	TorusGamesGraphicsViewMac.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import "GeometryGamesGraphicsViewMac.h"

@interface TorusGamesGraphicsViewMac : GeometryGamesGraphicsViewMac
{
}

- (id)initWithModel:(GeometryGamesModel *)aModel frame:(NSRect)aFrame;

- (void)handleApplicationWillResignActiveNotification:(NSNotification *)aNotification;
- (void)handleApplicationDidBecomeActiveNotification:(NSNotification *)aNotification;
- (void)handleWindowDidMiniaturizeNotification:(NSNotification *)aNotification;
- (void)handleWindowDidDeminiaturizeNotification:(NSNotification *)aNotification;

- (BOOL)acceptsFirstResponder;
- (void)keyDown:(NSEvent *)anEvent;
- (void)insertText:(id)aString;

#ifdef TORUS_GAMES_2D_MOUSE_INTERFACE
- (void)enterTorusCursorMode;
- (void)exitTorusCursorMode;
#endif

- (void)refreshRendererTexturesWithModelData:(ModelData *)md;
- (void)refreshRendererTexturesForGameResetWithModelData:(ModelData *)md;
- (void)refreshRendererTexturesForCharacterInputWithModelData:(ModelData *)md;

- (void)mouseMoved:(NSEvent *)anEvent;
- (void)mouseDown:(NSEvent *)anEvent;
- (void)mouseDragged:(NSEvent *)anEvent;
- (void)mouseUp:(NSEvent *)anEvent;
- (void)rightMouseDown:(NSEvent *)anEvent;
- (void)rightMouseDragged:(NSEvent *)anEvent;
- (void)rightMouseUp:(NSEvent *)anEvent;

- (void)touchesBeganWithEvent:(NSEvent *)anEvent;
- (void)touchesMovedWithEvent:(NSEvent *)anEvent;
- (void)touchesEndedWithEvent:(NSEvent *)anEvent;
- (void)touchesCancelledWithEvent:(NSEvent *)anEvent;

- (void)errorWithTitle:(ErrorText)aTitle message:(ErrorText)aMessage;

@end
